/**
 *
 */
package gov.va.med.mhv.phr.util;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.usermgmt.enumeration.ExtractEnablementStatus;
import gov.va.med.mhv.usermgmt.enumeration.ExtractType;
import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.util.ExtractEnablementStatusUtils;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public final class SessionManagement {

    private static final Log LOG = LogFactory.getLog(SessionManagement.class);

    private static final String PATIENT_ATTRIBUTE =
        "gov.va.med.mhv.phr.patient";

    private static final String EXTRACT_UPDATED_ATTRIBUTE =
        "gov.va.med.mhv.phr.extract.updated";

    private static final String FEATURE_VISIBLE_ATTRIBUTE_PREFIX =
        "gov.va.med.mhv.phr.extract.visible.";

    private static final String FEATURE_VISIBLE_CHECKED_ATTRIBUTE =
        "gov.va.med.mhv.phr.extract.visible.checked";

    //New session attribute that sets the string representation of extract
    //enablement status
    private static final String EXTRACT_ENABLEMENT_MAP_VAR =
    	"gov.va.med.mhv.phr.extract.enablement.status.map";

    private static final String LAST_FOIA_COUNT_TIME_ATTRIBUTE =
    	"gov.va.med.mhv.phr.extract.foia.time";


    private static final SessionManagement instance = new SessionManagement();

    /**
     * Returns a SessionManagement instance.
     * @return a SessionManagement instance.
     */
    public static final SessionManagement getInstance() {
        return instance;
    }

    /**
     * Hide constructor for singleton pattern
     */
    private SessionManagement() {
    	//hidden constructor and initializes the map
    }

    public Patient getPatient(HttpServletRequest request) {
        Precondition.assertNotNull("request", request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get patient from session "
                + request.getSession().getId()
                + " (request: " + request.getRequestURL() + ")");
        }
        return (Patient) request.getSession().getAttribute(
            PATIENT_ATTRIBUTE);
    }

    public void setPatient(HttpServletRequest request, Patient patient) {
        Precondition.assertNotNull("request", request);
        request.getSession().setAttribute(PATIENT_ATTRIBUTE, patient);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set patient " + patient + " in session "
                + request.getSession().getId()
                + " (request: " + request.getRequestURL() + ")");
        }
    }

    public void setExtractUpdated(HttpServletRequest request,
        ExtractType extractType, boolean updated)
    {
        Precondition.assertNotNull("request", request);
        Precondition.assertNotNull("extractType", extractType);
        request.getSession().setAttribute(createExtractAttribute(
            EXTRACT_UPDATED_ATTRIBUTE, extractType),
            (updated) ? Boolean.TRUE : Boolean.FALSE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set extract type updated to " + updated
                + " in session " + request.getSession().getId()
                + " (request: " + request.getRequestURL() + ")");
        }
    }

    public boolean isExtractUpdated(HttpServletRequest request,
        ExtractType extractType)
    {
        Precondition.assertNotNull("request", request);
        Precondition.assertNotNull("extractType", extractType);
        return BooleanUtils.isTrue((Boolean) request.getSession().getAttribute(
            createExtractAttribute(EXTRACT_UPDATED_ATTRIBUTE, extractType)));
    }


    private String createExtractAttribute(String attribute,
        ExtractType extractType)
    {
        Precondition.assertNotBlank("attribute", attribute);
        Precondition.assertNotNull("extractType", extractType);
        return  attribute + "." + extractType.getName();
    }

    @SuppressWarnings("unchecked")
	public void setExtractEnablementStatus(HttpServletRequest request,
    		ExtractType extractType, ExtractEnablementStatus status)
    {
    	Precondition.assertNotNull("request", request);
    	Precondition.assertNotNull("extractType", extractType);
    	Precondition.assertNotNull("status", status);

    	HttpSession session = request.getSession();
    	Map<ExtractType, ExtractEnablementStatus> map =
    		(Map<ExtractType, ExtractEnablementStatus>)
    		session.getAttribute(EXTRACT_ENABLEMENT_MAP_VAR);
    	if(map == null){
    		map = new HashMap<ExtractType, ExtractEnablementStatus>();
	    	session.setAttribute(EXTRACT_ENABLEMENT_MAP_VAR,map);
    	}
    	map.put(extractType, status);
    }


    @SuppressWarnings("unchecked")
	public ExtractEnablementStatus getExtractEnablementStatus
		(HttpServletRequest request, ExtractType extractType)
    {
    	HttpSession session = request.getSession();
    	ExtractEnablementStatus status = null;

    	Map<ExtractType, ExtractEnablementStatus> map =
    		(Map<ExtractType, ExtractEnablementStatus>)
    		session.getAttribute(EXTRACT_ENABLEMENT_MAP_VAR);

    	if(map != null){
    		status = (ExtractEnablementStatus)map.get(extractType);
    	}
    	if(status == null){
    		if(LOG.isDebugEnabled()){
    			LOG.debug("Using default status");
   			}
    		status = ExtractEnablementStatusUtils.DISABLED;
    	}
    	if(LOG.isDebugEnabled()){
    		LOG.debug("The extract type request is " + extractType
			 + " Enablement mapped to extract type is " +
			 status.getName());
   		}
    	return status;
    }

    public boolean isExtractEnabled(HttpServletRequest request,
    		ExtractType extractType)
    {
    	Precondition.assertNotNull("request", request);
    	Precondition.assertNotNull("extractType", extractType);
    	ExtractEnablementStatus  status =
    		getExtractEnablementStatus(request, extractType);

    	return (status == ExtractEnablementStatusUtils.ENABLED ||
    		    status == ExtractEnablementStatusUtils.PARTIAL);
    }

    public boolean isExtractPartialed(HttpServletRequest request,
    		ExtractType extractType){
     	Precondition.assertNotNull("request", request);
        Precondition.assertNotNull("extractType", extractType);

        ExtractEnablementStatus  status =
    		getExtractEnablementStatus(request, extractType);

    	return (status != ExtractEnablementStatusUtils.ENABLED &&
    			status == ExtractEnablementStatusUtils.PARTIAL);
     }

    public Date getLastFoiaCountTime(HttpServletRequest request) {
    	Precondition.assertNotNull("request", request);
    	return (Date)request.getSession().getAttribute(
    		LAST_FOIA_COUNT_TIME_ATTRIBUTE);
    }

    public void setLastFoiaCountTime(HttpServletRequest request) {
    	Precondition.assertNotNull("request", request);
    	request.getSession().setAttribute(LAST_FOIA_COUNT_TIME_ATTRIBUTE,
    		new Date());
    }
    public void setVisibilityValuesChecked(HttpServletRequest request,
    	boolean checked)
    {
   	    Precondition.assertNotNull("request", request);
        request.getSession().setAttribute(FEATURE_VISIBLE_CHECKED_ATTRIBUTE,
        	checked);
    }
    public boolean hasVisibilityValuesChecked(HttpServletRequest request) {
  	    Precondition.assertNotNull("request", request);
    	return BooleanUtils.isTrue((Boolean) request.getSession().
    			getAttribute(FEATURE_VISIBLE_CHECKED_ATTRIBUTE));
    }

    public void setFeatureVisible(HttpServletRequest request,
	    String featureName, boolean isVisible)
    {
  	    Precondition.assertNotNull("request", request);
  	    Precondition.assertNotNull("featureName", featureName);
        request.getSession().setAttribute(FEATURE_VISIBLE_ATTRIBUTE_PREFIX
        	+ featureName, isVisible);
    }

   public boolean isFeatureVisible(HttpServletRequest request,
	   String featureName)
   {
       Precondition.assertNotNull("request", request);
       Precondition.assertNotNull("featureName", featureName);
       return BooleanUtils.isTrue((Boolean) request.getSession().getAttribute(
           FEATURE_VISIBLE_ATTRIBUTE_PREFIX + featureName));
   }

//   public void setIsAppointmentFieldTester(HttpServletRequest request,
//	   String attrName, boolean checked)
//   {
//       Precondition.assertNotNull("request", request);
//	   	 Precondition.assertNotNull("attrName", attrName);
//	        request.getSession().setAttribute(attrName, checked);
//
//	   }
//      public boolean isAppointmentFieldTester(HttpServletRequest request,String attrName){
//	  	 Precondition.assertNotNull("request", request);
//	  	 Precondition.assertNotNull("attrName", attrName);
//	     return BooleanUtils.isTrue((Boolean) request.getSession().
//	    		 				getAttribute(attrName));
//
//	  }
//
//	  public void setIsSecureMsgFieldTester(HttpServletRequest request,String attrName,boolean checked){
//		 Precondition.assertNotNull("request", request);
//		 Precondition.assertNotNull("attrName", attrName);
//		 request.getSession().setAttribute(attrName, checked);
//
//	  }
//	  public boolean isSecureMsgFieldTester(HttpServletRequest request,String attrName){
//		Precondition.assertNotNull("request", request);
//		Precondition.assertNotNull("attrName", attrName);
//		return BooleanUtils.isTrue((Boolean) request.getSession().
//		    			getAttribute(attrName));
//
//	  }
//
//	  public void setIsWellnessReminderFieldTester(HttpServletRequest request, String attrName, boolean checked){
//		Precondition.assertNotNull("request", request);
//		Precondition.assertNotNull("attrName", attrName);
//		request.getSession().setAttribute(attrName, checked);
//
//	  }
//	  public boolean isWellnessReminderFieldTester(HttpServletRequest request, String attrName){
//		Precondition.assertNotNull("request", request);
//		Precondition.assertNotNull("attrName", attrName);
//		return BooleanUtils.isTrue((Boolean) request.getSession().
//			    			getAttribute(attrName));
//	  }

    public boolean isChemLabsVisible(HttpServletRequest request) {
        return isFeatureVisible(request, AccessFeatureValueUtils.
        	CHEMISTRYHEMATOLOGY.getName());
    }

    public boolean isAllergyVisible(HttpServletRequest request) {
        return isFeatureVisible(request, AccessFeatureValueUtils.
        	ALLERGY.getName());
    }

    public boolean isVbhHandbookVisible(HttpServletRequest request) {
        return isFeatureVisible(request, AccessFeatureValueUtils.
        	VBHHANDBOOK.getName());
    }

    public boolean isAppointmentsVisible(HttpServletRequest request){
        return isFeatureVisible(request, AccessFeatureValueUtils.APPOINTMENTS.
        	getName());
    }

    public boolean isSecureMessagingVisible(HttpServletRequest request){
        return isFeatureVisible(request,AccessFeatureValueUtils.SECUREMESSAGING.
        	getName());
    }

    public boolean isWellnessRemindersVisible(HttpServletRequest request){
        return isFeatureVisible(request, AccessFeatureValueUtils.
        	WELLNESSREMINDERS.getName());
    }

    public boolean isMyGoalsVisible(HttpServletRequest request){
        return isFeatureVisible(request, AccessFeatureValueUtils.
        	MYGOALS.getName());
    }

    public boolean isHraVisible(HttpServletRequest request){
        return isFeatureVisible(request, AccessFeatureValueUtils.VAHRA.getName());
    }

    public boolean isMyMedsVisible(HttpServletRequest request){
	        return isFeatureVisible(request, AccessFeatureValueUtils.MYMEDS.getName());
    }

    public void setChemLabsVisible(HttpServletRequest request,
    	boolean isVisible)
    {
        setFeatureVisible(request, AccessFeatureValueUtils.CHEMISTRYHEMATOLOGY.
        	getName(), isVisible);
    }

    public void setAllergyVisible(HttpServletRequest request,
        	boolean isVisible)
    {
        setFeatureVisible(request, AccessFeatureValueUtils.ALLERGY.
        	getName(), isVisible);
    }

    public void setVbhHandbookVisible(HttpServletRequest request,
        	boolean isVisible)
    {
        setFeatureVisible(request, AccessFeatureValueUtils.VBHHANDBOOK.
        	getName(), isVisible);
    }

    public void setAppointmentsVisible(HttpServletRequest request,
       	boolean isVisible)
    {
        setFeatureVisible(request, AccessFeatureValueUtils.APPOINTMENTS.
        	getName(), isVisible);
    }

    public void setSecureMessagingVisible(HttpServletRequest request,
        boolean isVisible)
    {
        setFeatureVisible(request,AccessFeatureValueUtils.SECUREMESSAGING.
        	getName(), isVisible);
    }

    public void setWellnessRemindersVisible(HttpServletRequest request,
        boolean isVisible)
   {
        setFeatureVisible(request, AccessFeatureValueUtils.
        	WELLNESSREMINDERS.getName(), isVisible);
   }

    public void setMyGoalsVisible(HttpServletRequest request,
        boolean isVisible)
   {
    	LOG.debug("****** setMyGoalsVisible");
        setFeatureVisible(request, AccessFeatureValueUtils.
        	MYGOALS.getName(), isVisible);
    }

    public void setHraVisible(HttpServletRequest request,
            boolean isVisible)
     {
     	LOG.debug("****** setHraVisible");
        setFeatureVisible(request, AccessFeatureValueUtils.VAHRA.getName(), isVisible);
     }

     public void setMyMedsVisible(HttpServletRequest request,
	             boolean isVisible)
	 {
	    LOG.debug("****** setMyMedsVisible");
	    setFeatureVisible(request, AccessFeatureValueUtils.MYMEDS.getName(), isVisible);
     }
}
